package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class QuoteRequestCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private QuoteRequest quoteRequest;

  private String type;

  public QuoteRequestCreated() {
  }

  public QuoteRequestCreated(QuoteRequest quoteRequest, String type) {
    this.quoteRequest = quoteRequest;
    this.type = type;
  }

  public QuoteRequest getQuoteRequest() {
    return quoteRequest;
  }

  public void setQuoteRequest(QuoteRequest quoteRequest) {
    this.quoteRequest = quoteRequest;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "QuoteRequestCreated{quoteRequest='" + quoteRequest + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteRequestCreated that = (QuoteRequestCreated) o;
    return Objects.equals(quoteRequest, that.quoteRequest) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quoteRequest, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private QuoteRequest quoteRequest;

    private String type;

    public QuoteRequestCreated build() {
      QuoteRequestCreated result = new QuoteRequestCreated();
      result.quoteRequest = this.quoteRequest;
      result.type = this.type;
      return result;
    }

    public Builder quoteRequest(QuoteRequest quoteRequest) {
      this.quoteRequest = quoteRequest;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
