package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class QuoteRequestDraft {
  private String key;

  private ResourceIdentifierInput cart;

  private String comment;

  private Long cartVersion;

  private CustomFieldsDraft custom;

  private ReferenceInput state;

  private String purchaseOrderNumber;

  public QuoteRequestDraft() {
  }

  public QuoteRequestDraft(String key, ResourceIdentifierInput cart, String comment,
      Long cartVersion, CustomFieldsDraft custom, ReferenceInput state,
      String purchaseOrderNumber) {
    this.key = key;
    this.cart = cart;
    this.comment = comment;
    this.cartVersion = cartVersion;
    this.custom = custom;
    this.state = state;
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ResourceIdentifierInput getCart() {
    return cart;
  }

  public void setCart(ResourceIdentifierInput cart) {
    this.cart = cart;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public Long getCartVersion() {
    return cartVersion;
  }

  public void setCartVersion(Long cartVersion) {
    this.cartVersion = cartVersion;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ReferenceInput getState() {
    return state;
  }

  public void setState(ReferenceInput state) {
    this.state = state;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  @Override
  public String toString() {
    return "QuoteRequestDraft{key='" + key + "', cart='" + cart + "', comment='" + comment + "', cartVersion='" + cartVersion + "', custom='" + custom + "', state='" + state + "', purchaseOrderNumber='" + purchaseOrderNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteRequestDraft that = (QuoteRequestDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(cart, that.cart) &&
        Objects.equals(comment, that.comment) &&
        Objects.equals(cartVersion, that.cartVersion) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(state, that.state) &&
        Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, cart, comment, cartVersion, custom, state, purchaseOrderNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ResourceIdentifierInput cart;

    private String comment;

    private Long cartVersion;

    private CustomFieldsDraft custom;

    private ReferenceInput state;

    private String purchaseOrderNumber;

    public QuoteRequestDraft build() {
      QuoteRequestDraft result = new QuoteRequestDraft();
      result.key = this.key;
      result.cart = this.cart;
      result.comment = this.comment;
      result.cartVersion = this.cartVersion;
      result.custom = this.custom;
      result.state = this.state;
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder cart(ResourceIdentifierInput cart) {
      this.cart = cart;
      return this;
    }

    public Builder comment(String comment) {
      this.comment = comment;
      return this;
    }

    public Builder cartVersion(Long cartVersion) {
      this.cartVersion = cartVersion;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder state(ReferenceInput state) {
      this.state = state;
      return this;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }
  }
}
