package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Fields to access QuoteRequests.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes(@JsonSubTypes.Type(value = AsAssociate.class, name = "AsAssociate"))
public interface QuoteRequestQueryInterface {
  QuoteRequest getQuoteRequest();

  void setQuoteRequest(QuoteRequest quoteRequest);

  QuoteRequestQueryResult getQuoteRequests();

  void setQuoteRequests(QuoteRequestQueryResult quoteRequests);
}
