package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class QuoteStateChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private QuoteState quoteState;

  private QuoteState oldQuoteState;

  private String type;

  public QuoteStateChanged() {
  }

  public QuoteStateChanged(QuoteState quoteState, QuoteState oldQuoteState, String type) {
    this.quoteState = quoteState;
    this.oldQuoteState = oldQuoteState;
    this.type = type;
  }

  public QuoteState getQuoteState() {
    return quoteState;
  }

  public void setQuoteState(QuoteState quoteState) {
    this.quoteState = quoteState;
  }

  public QuoteState getOldQuoteState() {
    return oldQuoteState;
  }

  public void setOldQuoteState(QuoteState oldQuoteState) {
    this.oldQuoteState = oldQuoteState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "QuoteStateChanged{quoteState='" + quoteState + "', oldQuoteState='" + oldQuoteState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteStateChanged that = (QuoteStateChanged) o;
    return Objects.equals(quoteState, that.quoteState) &&
        Objects.equals(oldQuoteState, that.oldQuoteState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quoteState, oldQuoteState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private QuoteState quoteState;

    private QuoteState oldQuoteState;

    private String type;

    public QuoteStateChanged build() {
      QuoteStateChanged result = new QuoteStateChanged();
      result.quoteState = this.quoteState;
      result.oldQuoteState = this.oldQuoteState;
      result.type = this.type;
      return result;
    }

    public Builder quoteState(QuoteState quoteState) {
      this.quoteState = quoteState;
      return this;
    }

    public Builder oldQuoteState(QuoteState oldQuoteState) {
      this.oldQuoteState = oldQuoteState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
