package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class QuoteUpdateAction {
  private ChangeQuoteCustomer changeCustomer;

  private ChangeQuoteState changeQuoteState;

  private RequestQuoteRenegotiation requestQuoteRenegotiation;

  private SetQuoteCustomField setCustomField;

  private SetQuoteCustomType setCustomType;

  private TransitionQuoteState transitionState;

  public QuoteUpdateAction() {
  }

  public QuoteUpdateAction(ChangeQuoteCustomer changeCustomer, ChangeQuoteState changeQuoteState,
      RequestQuoteRenegotiation requestQuoteRenegotiation, SetQuoteCustomField setCustomField,
      SetQuoteCustomType setCustomType, TransitionQuoteState transitionState) {
    this.changeCustomer = changeCustomer;
    this.changeQuoteState = changeQuoteState;
    this.requestQuoteRenegotiation = requestQuoteRenegotiation;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.transitionState = transitionState;
  }

  public ChangeQuoteCustomer getChangeCustomer() {
    return changeCustomer;
  }

  public void setChangeCustomer(ChangeQuoteCustomer changeCustomer) {
    this.changeCustomer = changeCustomer;
  }

  public ChangeQuoteState getChangeQuoteState() {
    return changeQuoteState;
  }

  public void setChangeQuoteState(ChangeQuoteState changeQuoteState) {
    this.changeQuoteState = changeQuoteState;
  }

  public RequestQuoteRenegotiation getRequestQuoteRenegotiation() {
    return requestQuoteRenegotiation;
  }

  public void setRequestQuoteRenegotiation(RequestQuoteRenegotiation requestQuoteRenegotiation) {
    this.requestQuoteRenegotiation = requestQuoteRenegotiation;
  }

  public SetQuoteCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetQuoteCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetQuoteCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetQuoteCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public TransitionQuoteState getTransitionState() {
    return transitionState;
  }

  public void setTransitionState(TransitionQuoteState transitionState) {
    this.transitionState = transitionState;
  }

  @Override
  public String toString() {
    return "QuoteUpdateAction{changeCustomer='" + changeCustomer + "', changeQuoteState='" + changeQuoteState + "', requestQuoteRenegotiation='" + requestQuoteRenegotiation + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', transitionState='" + transitionState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    QuoteUpdateAction that = (QuoteUpdateAction) o;
    return Objects.equals(changeCustomer, that.changeCustomer) &&
        Objects.equals(changeQuoteState, that.changeQuoteState) &&
        Objects.equals(requestQuoteRenegotiation, that.requestQuoteRenegotiation) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(transitionState, that.transitionState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeCustomer, changeQuoteState, requestQuoteRenegotiation, setCustomField, setCustomType, transitionState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeQuoteCustomer changeCustomer;

    private ChangeQuoteState changeQuoteState;

    private RequestQuoteRenegotiation requestQuoteRenegotiation;

    private SetQuoteCustomField setCustomField;

    private SetQuoteCustomType setCustomType;

    private TransitionQuoteState transitionState;

    public QuoteUpdateAction build() {
      QuoteUpdateAction result = new QuoteUpdateAction();
      result.changeCustomer = this.changeCustomer;
      result.changeQuoteState = this.changeQuoteState;
      result.requestQuoteRenegotiation = this.requestQuoteRenegotiation;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.transitionState = this.transitionState;
      return result;
    }

    public Builder changeCustomer(ChangeQuoteCustomer changeCustomer) {
      this.changeCustomer = changeCustomer;
      return this;
    }

    public Builder changeQuoteState(ChangeQuoteState changeQuoteState) {
      this.changeQuoteState = changeQuoteState;
      return this;
    }

    public Builder requestQuoteRenegotiation(RequestQuoteRenegotiation requestQuoteRenegotiation) {
      this.requestQuoteRenegotiation = requestQuoteRenegotiation;
      return this;
    }

    public Builder setCustomField(SetQuoteCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetQuoteCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder transitionState(TransitionQuoteState transitionState) {
      this.transitionState = transitionState;
      return this;
    }
  }
}
