package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = RangeCountDouble.class, name = "RangeCountDouble"),
    @JsonSubTypes.Type(value = RangeCountLong.class, name = "RangeCountLong")
})
public interface RangeCount {
  String getType();

  void setType(String type);
}
