package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RangeCountDouble implements com.commercetools.graphql.api.types.RangeCount {
  private Double from;

  private String fromStr;

  private Double to;

  private String toStr;

  private Integer count;

  private Integer productCount;

  private Integer totalCount;

  private Double total;

  private Double min;

  private Double max;

  private Double mean;

  private String type;

  public RangeCountDouble() {
  }

  public RangeCountDouble(Double from, String fromStr, Double to, String toStr, Integer count,
      Integer productCount, Integer totalCount, Double total, Double min, Double max, Double mean,
      String type) {
    this.from = from;
    this.fromStr = fromStr;
    this.to = to;
    this.toStr = toStr;
    this.count = count;
    this.productCount = productCount;
    this.totalCount = totalCount;
    this.total = total;
    this.min = min;
    this.max = max;
    this.mean = mean;
    this.type = type;
  }

  public Double getFrom() {
    return from;
  }

  public void setFrom(Double from) {
    this.from = from;
  }

  public String getFromStr() {
    return fromStr;
  }

  public void setFromStr(String fromStr) {
    this.fromStr = fromStr;
  }

  public Double getTo() {
    return to;
  }

  public void setTo(Double to) {
    this.to = to;
  }

  public String getToStr() {
    return toStr;
  }

  public void setToStr(String toStr) {
    this.toStr = toStr;
  }

  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public Integer getProductCount() {
    return productCount;
  }

  public void setProductCount(Integer productCount) {
    this.productCount = productCount;
  }

  public Integer getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  public Double getTotal() {
    return total;
  }

  public void setTotal(Double total) {
    this.total = total;
  }

  public Double getMin() {
    return min;
  }

  public void setMin(Double min) {
    this.min = min;
  }

  public Double getMax() {
    return max;
  }

  public void setMax(Double max) {
    this.max = max;
  }

  public Double getMean() {
    return mean;
  }

  public void setMean(Double mean) {
    this.mean = mean;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "RangeCountDouble{from='" + from + "', fromStr='" + fromStr + "', to='" + to + "', toStr='" + toStr + "', count='" + count + "', productCount='" + productCount + "', totalCount='" + totalCount + "', total='" + total + "', min='" + min + "', max='" + max + "', mean='" + mean + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RangeCountDouble that = (RangeCountDouble) o;
    return Objects.equals(from, that.from) &&
        Objects.equals(fromStr, that.fromStr) &&
        Objects.equals(to, that.to) &&
        Objects.equals(toStr, that.toStr) &&
        Objects.equals(count, that.count) &&
        Objects.equals(productCount, that.productCount) &&
        Objects.equals(totalCount, that.totalCount) &&
        Objects.equals(total, that.total) &&
        Objects.equals(min, that.min) &&
        Objects.equals(max, that.max) &&
        Objects.equals(mean, that.mean) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, fromStr, to, toStr, count, productCount, totalCount, total, min, max, mean, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Double from;

    private String fromStr;

    private Double to;

    private String toStr;

    private Integer count;

    private Integer productCount;

    private Integer totalCount;

    private Double total;

    private Double min;

    private Double max;

    private Double mean;

    private String type;

    public RangeCountDouble build() {
      RangeCountDouble result = new RangeCountDouble();
      result.from = this.from;
      result.fromStr = this.fromStr;
      result.to = this.to;
      result.toStr = this.toStr;
      result.count = this.count;
      result.productCount = this.productCount;
      result.totalCount = this.totalCount;
      result.total = this.total;
      result.min = this.min;
      result.max = this.max;
      result.mean = this.mean;
      result.type = this.type;
      return result;
    }

    public Builder from(Double from) {
      this.from = from;
      return this;
    }

    public Builder fromStr(String fromStr) {
      this.fromStr = fromStr;
      return this;
    }

    public Builder to(Double to) {
      this.to = to;
      return this;
    }

    public Builder toStr(String toStr) {
      this.toStr = toStr;
      return this;
    }

    public Builder count(Integer count) {
      this.count = count;
      return this;
    }

    public Builder productCount(Integer productCount) {
      this.productCount = productCount;
      return this;
    }

    public Builder totalCount(Integer totalCount) {
      this.totalCount = totalCount;
      return this;
    }

    public Builder total(Double total) {
      this.total = total;
      return this;
    }

    public Builder min(Double min) {
      this.min = min;
      return this;
    }

    public Builder max(Double max) {
      this.max = max;
      return this;
    }

    public Builder mean(Double mean) {
      this.mean = mean;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
