package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RangeElementInput {
  private String from;

  private String to;

  public RangeElementInput() {
  }

  public RangeElementInput(String from, String to) {
    this.from = from;
    this.to = to;
  }

  public String getFrom() {
    return from;
  }

  public void setFrom(String from) {
    this.from = from;
  }

  public String getTo() {
    return to;
  }

  public void setTo(String to) {
    this.to = to;
  }

  @Override
  public String toString() {
    return "RangeElementInput{from='" + from + "', to='" + to + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RangeElementInput that = (RangeElementInput) o;
    return Objects.equals(from, that.from) &&
        Objects.equals(to, that.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, to);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String from;

    private String to;

    public RangeElementInput build() {
      RangeElementInput result = new RangeElementInput();
      result.from = this.from;
      result.to = this.to;
      return result;
    }

    public Builder from(String from) {
      this.from = from;
      return this;
    }

    public Builder to(String to) {
      this.to = to;
      return this;
    }
  }
}
