package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RecalculateCart {
  private Boolean updateProductData = false;

  public RecalculateCart() {
  }

  public RecalculateCart(Boolean updateProductData) {
    this.updateProductData = updateProductData;
  }

  public Boolean getUpdateProductData() {
    return updateProductData;
  }

  public void setUpdateProductData(Boolean updateProductData) {
    this.updateProductData = updateProductData;
  }

  @Override
  public String toString() {
    return "RecalculateCart{updateProductData='" + updateProductData + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RecalculateCart that = (RecalculateCart) o;
    return Objects.equals(updateProductData, that.updateProductData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(updateProductData);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean updateProductData = false;

    public RecalculateCart build() {
      RecalculateCart result = new RecalculateCart();
      result.updateProductData = this.updateProductData;
      return result;
    }

    public Builder updateProductData(Boolean updateProductData) {
      this.updateProductData = updateProductData;
      return this;
    }
  }
}
