package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AssociateRole.class, name = "AssociateRole"),
    @JsonSubTypes.Type(value = BusinessUnit.class, name = "BusinessUnit"),
    @JsonSubTypes.Type(value = Cart.class, name = "Cart"),
    @JsonSubTypes.Type(value = CartDiscount.class, name = "CartDiscount"),
    @JsonSubTypes.Type(value = Category.class, name = "Category"),
    @JsonSubTypes.Type(value = Channel.class, name = "Channel"),
    @JsonSubTypes.Type(value = CustomObject.class, name = "CustomObject"),
    @JsonSubTypes.Type(value = Customer.class, name = "Customer"),
    @JsonSubTypes.Type(value = CustomerGroup.class, name = "CustomerGroup"),
    @JsonSubTypes.Type(value = DiscountCode.class, name = "DiscountCode"),
    @JsonSubTypes.Type(value = Extension.class, name = "Extension"),
    @JsonSubTypes.Type(value = InventoryEntry.class, name = "InventoryEntry"),
    @JsonSubTypes.Type(value = Message.class, name = "Message"),
    @JsonSubTypes.Type(value = Order.class, name = "Order"),
    @JsonSubTypes.Type(value = Product.class, name = "Product"),
    @JsonSubTypes.Type(value = ProductDiscount.class, name = "ProductDiscount"),
    @JsonSubTypes.Type(value = ProductTypeDefinition.class, name = "ProductTypeDefinition"),
    @JsonSubTypes.Type(value = Review.class, name = "Review"),
    @JsonSubTypes.Type(value = ShippingMethod.class, name = "ShippingMethod"),
    @JsonSubTypes.Type(value = ShoppingList.class, name = "ShoppingList"),
    @JsonSubTypes.Type(value = State.class, name = "State"),
    @JsonSubTypes.Type(value = Store.class, name = "Store"),
    @JsonSubTypes.Type(value = TaxCategory.class, name = "TaxCategory"),
    @JsonSubTypes.Type(value = TypeDefinition.class, name = "TypeDefinition"),
    @JsonSubTypes.Type(value = Zone.class, name = "Zone")
})
public interface ReferenceExpandable {
  String getId();

  void setId(String id);
}
