package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RefreshTokenLimitsProjection {
  private RefreshTokenLimitWithCurrent total;

  public RefreshTokenLimitsProjection() {
  }

  public RefreshTokenLimitsProjection(RefreshTokenLimitWithCurrent total) {
    this.total = total;
  }

  public RefreshTokenLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(RefreshTokenLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "RefreshTokenLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RefreshTokenLimitsProjection that = (RefreshTokenLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private RefreshTokenLimitWithCurrent total;

    public RefreshTokenLimitsProjection build() {
      RefreshTokenLimitsProjection result = new RefreshTokenLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(RefreshTokenLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
