package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveAttributeGroupAttribute {
  private AttributeReferenceInput attribute;

  public RemoveAttributeGroupAttribute() {
  }

  public RemoveAttributeGroupAttribute(AttributeReferenceInput attribute) {
    this.attribute = attribute;
  }

  public AttributeReferenceInput getAttribute() {
    return attribute;
  }

  public void setAttribute(AttributeReferenceInput attribute) {
    this.attribute = attribute;
  }

  @Override
  public String toString() {
    return "RemoveAttributeGroupAttribute{attribute='" + attribute + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveAttributeGroupAttribute that = (RemoveAttributeGroupAttribute) o;
    return Objects.equals(attribute, that.attribute);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attribute);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AttributeReferenceInput attribute;

    public RemoveAttributeGroupAttribute build() {
      RemoveAttributeGroupAttribute result = new RemoveAttributeGroupAttribute();
      result.attribute = this.attribute;
      return result;
    }

    public Builder attribute(AttributeReferenceInput attribute) {
      this.attribute = attribute;
      return this;
    }
  }
}
