package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveBusinessUnitStore {
  private ResourceIdentifierInput store;

  public RemoveBusinessUnitStore() {
  }

  public RemoveBusinessUnitStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  public ResourceIdentifierInput getStore() {
    return store;
  }

  public void setStore(ResourceIdentifierInput store) {
    this.store = store;
  }

  @Override
  public String toString() {
    return "RemoveBusinessUnitStore{store='" + store + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveBusinessUnitStore that = (RemoveBusinessUnitStore) o;
    return Objects.equals(store, that.store);
  }

  @Override
  public int hashCode() {
    return Objects.hash(store);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput store;

    public RemoveBusinessUnitStore build() {
      RemoveBusinessUnitStore result = new RemoveBusinessUnitStore();
      result.store = this.store;
      return result;
    }

    public Builder store(ResourceIdentifierInput store) {
      this.store = store;
      return this;
    }
  }
}
