package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveCartItemShippingAddress {
  private String addressKey;

  public RemoveCartItemShippingAddress() {
  }

  public RemoveCartItemShippingAddress(String addressKey) {
    this.addressKey = addressKey;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  @Override
  public String toString() {
    return "RemoveCartItemShippingAddress{addressKey='" + addressKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveCartItemShippingAddress that = (RemoveCartItemShippingAddress) o;
    return Objects.equals(addressKey, that.addressKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String addressKey;

    public RemoveCartItemShippingAddress build() {
      RemoveCartItemShippingAddress result = new RemoveCartItemShippingAddress();
      result.addressKey = this.addressKey;
      return result;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }
  }
}
