package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class RemoveCustomerGroupAssignment {
  private ResourceIdentifierInput customerGroup;

  public RemoveCustomerGroupAssignment() {
  }

  public RemoveCustomerGroupAssignment(ResourceIdentifierInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  public ResourceIdentifierInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ResourceIdentifierInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  @Override
  public String toString() {
    return "RemoveCustomerGroupAssignment{customerGroup='" + customerGroup + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveCustomerGroupAssignment that = (RemoveCustomerGroupAssignment) o;
    return Objects.equals(customerGroup, that.customerGroup);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroup);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput customerGroup;

    public RemoveCustomerGroupAssignment build() {
      RemoveCustomerGroupAssignment result = new RemoveCustomerGroupAssignment();
      result.customerGroup = this.customerGroup;
      return result;
    }

    public Builder customerGroup(ResourceIdentifierInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }
  }
}
