package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveInventoryEntryQuantity {
  private Long quantity;

  public RemoveInventoryEntryQuantity() {
  }

  public RemoveInventoryEntryQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  @Override
  public String toString() {
    return "RemoveInventoryEntryQuantity{quantity='" + quantity + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveInventoryEntryQuantity that = (RemoveInventoryEntryQuantity) o;
    return Objects.equals(quantity, that.quantity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quantity);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long quantity;

    public RemoveInventoryEntryQuantity build() {
      RemoveInventoryEntryQuantity result = new RemoveInventoryEntryQuantity();
      result.quantity = this.quantity;
      return result;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }
  }
}
