package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveOrderParcelFromDelivery {
  private String parcelId;

  private String parcelKey;

  public RemoveOrderParcelFromDelivery() {
  }

  public RemoveOrderParcelFromDelivery(String parcelId, String parcelKey) {
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  @Override
  public String toString() {
    return "RemoveOrderParcelFromDelivery{parcelId='" + parcelId + "', parcelKey='" + parcelKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveOrderParcelFromDelivery that = (RemoveOrderParcelFromDelivery) o;
    return Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parcelId, parcelKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String parcelId;

    private String parcelKey;

    public RemoveOrderParcelFromDelivery build() {
      RemoveOrderParcelFromDelivery result = new RemoveOrderParcelFromDelivery();
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      return result;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }
  }
}
