package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveProductSelectionProduct {
  private ResourceIdentifierInput product;

  public RemoveProductSelectionProduct() {
  }

  public RemoveProductSelectionProduct(ResourceIdentifierInput product) {
    this.product = product;
  }

  public ResourceIdentifierInput getProduct() {
    return product;
  }

  public void setProduct(ResourceIdentifierInput product) {
    this.product = product;
  }

  @Override
  public String toString() {
    return "RemoveProductSelectionProduct{product='" + product + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveProductSelectionProduct that = (RemoveProductSelectionProduct) o;
    return Objects.equals(product, that.product);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput product;

    public RemoveProductSelectionProduct build() {
      RemoveProductSelectionProduct result = new RemoveProductSelectionProduct();
      result.product = this.product;
      return result;
    }

    public Builder product(ResourceIdentifierInput product) {
      this.product = product;
      return this;
    }
  }
}
