package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RemoveStagedChanges {
  private String dummy;

  public RemoveStagedChanges() {
  }

  public RemoveStagedChanges(String dummy) {
    this.dummy = dummy;
  }

  public String getDummy() {
    return dummy;
  }

  public void setDummy(String dummy) {
    this.dummy = dummy;
  }

  @Override
  public String toString() {
    return "RemoveStagedChanges{dummy='" + dummy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedChanges that = (RemoveStagedChanges) o;
    return Objects.equals(dummy, that.dummy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dummy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String dummy;

    public RemoveStagedChanges build() {
      RemoveStagedChanges result = new RemoveStagedChanges();
      result.dummy = this.dummy;
      return result;
    }

    public Builder dummy(String dummy) {
      this.dummy = dummy;
      return this;
    }
  }
}
