package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RemoveStagedOrderCustomLineItemOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String customLineItemId;

  private String customLineItemKey;

  public RemoveStagedOrderCustomLineItemOutput() {
  }

  public RemoveStagedOrderCustomLineItemOutput(String type, String customLineItemId,
      String customLineItemKey) {
    this.type = type;
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderCustomLineItemOutput{type='" + type + "', customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderCustomLineItemOutput that = (RemoveStagedOrderCustomLineItemOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customLineItemId, customLineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customLineItemId;

    private String customLineItemKey;

    public RemoveStagedOrderCustomLineItemOutput build() {
      RemoveStagedOrderCustomLineItemOutput result = new RemoveStagedOrderCustomLineItemOutput();
      result.type = this.type;
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }
  }
}
