package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RemoveStagedOrderDeliveryOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String deliveryId;

  private String deliveryKey;

  public RemoveStagedOrderDeliveryOutput() {
  }

  public RemoveStagedOrderDeliveryOutput(String type, String deliveryId, String deliveryKey) {
    this.type = type;
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderDeliveryOutput{type='" + type + "', deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderDeliveryOutput that = (RemoveStagedOrderDeliveryOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, deliveryId, deliveryKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String deliveryId;

    private String deliveryKey;

    public RemoveStagedOrderDeliveryOutput build() {
      RemoveStagedOrderDeliveryOutput result = new RemoveStagedOrderDeliveryOutput();
      result.type = this.type;
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }
  }
}
