package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RemoveStagedOrderLineItemOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private Long quantity;

  private String lineItemKey;

  private BaseMoney externalPrice;

  private ExternalLineItemTotalPrice externalTotalPrice;

  private ItemShippingDetailsDraftOutput shippingDetailsToRemove;

  public RemoveStagedOrderLineItemOutput() {
  }

  public RemoveStagedOrderLineItemOutput(String type, String lineItemId, Long quantity,
      String lineItemKey, BaseMoney externalPrice, ExternalLineItemTotalPrice externalTotalPrice,
      ItemShippingDetailsDraftOutput shippingDetailsToRemove) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.quantity = quantity;
    this.lineItemKey = lineItemKey;
    this.externalPrice = externalPrice;
    this.externalTotalPrice = externalTotalPrice;
    this.shippingDetailsToRemove = shippingDetailsToRemove;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public BaseMoney getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoney externalPrice) {
    this.externalPrice = externalPrice;
  }

  public ExternalLineItemTotalPrice getExternalTotalPrice() {
    return externalTotalPrice;
  }

  public void setExternalTotalPrice(ExternalLineItemTotalPrice externalTotalPrice) {
    this.externalTotalPrice = externalTotalPrice;
  }

  public ItemShippingDetailsDraftOutput getShippingDetailsToRemove() {
    return shippingDetailsToRemove;
  }

  public void setShippingDetailsToRemove(ItemShippingDetailsDraftOutput shippingDetailsToRemove) {
    this.shippingDetailsToRemove = shippingDetailsToRemove;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderLineItemOutput{type='" + type + "', lineItemId='" + lineItemId + "', quantity='" + quantity + "', lineItemKey='" + lineItemKey + "', externalPrice='" + externalPrice + "', externalTotalPrice='" + externalTotalPrice + "', shippingDetailsToRemove='" + shippingDetailsToRemove + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderLineItemOutput that = (RemoveStagedOrderLineItemOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(externalTotalPrice, that.externalTotalPrice) &&
        Objects.equals(shippingDetailsToRemove, that.shippingDetailsToRemove);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, quantity, lineItemKey, externalPrice, externalTotalPrice, shippingDetailsToRemove);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private Long quantity;

    private String lineItemKey;

    private BaseMoney externalPrice;

    private ExternalLineItemTotalPrice externalTotalPrice;

    private ItemShippingDetailsDraftOutput shippingDetailsToRemove;

    public RemoveStagedOrderLineItemOutput build() {
      RemoveStagedOrderLineItemOutput result = new RemoveStagedOrderLineItemOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.quantity = this.quantity;
      result.lineItemKey = this.lineItemKey;
      result.externalPrice = this.externalPrice;
      result.externalTotalPrice = this.externalTotalPrice;
      result.shippingDetailsToRemove = this.shippingDetailsToRemove;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder externalPrice(BaseMoney externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    public Builder externalTotalPrice(ExternalLineItemTotalPrice externalTotalPrice) {
      this.externalTotalPrice = externalTotalPrice;
      return this;
    }

    public Builder shippingDetailsToRemove(ItemShippingDetailsDraftOutput shippingDetailsToRemove) {
      this.shippingDetailsToRemove = shippingDetailsToRemove;
      return this;
    }
  }
}
