package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RemoveStagedOrderParcelFromDeliveryOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String parcelId;

  private String parcelKey;

  public RemoveStagedOrderParcelFromDeliveryOutput() {
  }

  public RemoveStagedOrderParcelFromDeliveryOutput(String type, String parcelId, String parcelKey) {
    this.type = type;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderParcelFromDeliveryOutput{type='" + type + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderParcelFromDeliveryOutput that = (RemoveStagedOrderParcelFromDeliveryOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, parcelId, parcelKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String parcelId;

    private String parcelKey;

    public RemoveStagedOrderParcelFromDeliveryOutput build() {
      RemoveStagedOrderParcelFromDeliveryOutput result = new RemoveStagedOrderParcelFromDeliveryOutput();
      result.type = this.type;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }
  }
}
