package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class RemoveStagedOrderPaymentOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ResourceIdentifier paymentResId;

  public RemoveStagedOrderPaymentOutput() {
  }

  public RemoveStagedOrderPaymentOutput(String type, ResourceIdentifier paymentResId) {
    this.type = type;
    this.paymentResId = paymentResId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceIdentifier getPaymentResId() {
    return paymentResId;
  }

  public void setPaymentResId(ResourceIdentifier paymentResId) {
    this.paymentResId = paymentResId;
  }

  @Override
  public String toString() {
    return "RemoveStagedOrderPaymentOutput{type='" + type + "', paymentResId='" + paymentResId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStagedOrderPaymentOutput that = (RemoveStagedOrderPaymentOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(paymentResId, that.paymentResId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, paymentResId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ResourceIdentifier paymentResId;

    public RemoveStagedOrderPaymentOutput build() {
      RemoveStagedOrderPaymentOutput result = new RemoveStagedOrderPaymentOutput();
      result.type = this.type;
      result.paymentResId = this.paymentResId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder paymentResId(ResourceIdentifier paymentResId) {
      this.paymentResId = paymentResId;
      return this;
    }
  }
}
