package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class RemoveStateRoles {
  private List<StateRole> roles;

  public RemoveStateRoles() {
  }

  public RemoveStateRoles(List<StateRole> roles) {
    this.roles = roles;
  }

  public List<StateRole> getRoles() {
    return roles;
  }

  public void setRoles(List<StateRole> roles) {
    this.roles = roles;
  }

  @Override
  public String toString() {
    return "RemoveStateRoles{roles='" + roles + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RemoveStateRoles that = (RemoveStateRoles) o;
    return Objects.equals(roles, that.roles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roles);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<StateRole> roles;

    public RemoveStateRoles build() {
      RemoveStateRoles result = new RemoveStateRoles();
      result.roles = this.roles;
      return result;
    }

    public Builder roles(List<StateRole> roles) {
      this.roles = roles;
      return this;
    }
  }
}
