package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RequestQuoteRenegotiation {
  private String buyerComment;

  public RequestQuoteRenegotiation() {
  }

  public RequestQuoteRenegotiation(String buyerComment) {
    this.buyerComment = buyerComment;
  }

  public String getBuyerComment() {
    return buyerComment;
  }

  public void setBuyerComment(String buyerComment) {
    this.buyerComment = buyerComment;
  }

  @Override
  public String toString() {
    return "RequestQuoteRenegotiation{buyerComment='" + buyerComment + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestQuoteRenegotiation that = (RequestQuoteRenegotiation) o;
    return Objects.equals(buyerComment, that.buyerComment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(buyerComment);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String buyerComment;

    public RequestQuoteRenegotiation build() {
      RequestQuoteRenegotiation result = new RequestQuoteRenegotiation();
      result.buyerComment = this.buyerComment;
      return result;
    }

    public Builder buyerComment(String buyerComment) {
      this.buyerComment = buyerComment;
      return this;
    }
  }
}
