package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ResourceIdentifier {
  private String typeId;

  private String key;

  private String id;

  public ResourceIdentifier() {
  }

  public ResourceIdentifier(String typeId, String key, String id) {
    this.typeId = typeId;
    this.key = key;
    this.id = id;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @Override
  public String toString() {
    return "ResourceIdentifier{typeId='" + typeId + "', key='" + key + "', id='" + id + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceIdentifier that = (ResourceIdentifier) o;
    return Objects.equals(typeId, that.typeId) &&
        Objects.equals(key, that.key) &&
        Objects.equals(id, that.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeId, key, id);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String typeId;

    private String key;

    private String id;

    public ResourceIdentifier build() {
      ResourceIdentifier result = new ResourceIdentifier();
      result.typeId = this.typeId;
      result.key = this.key;
      result.id = this.id;
      return result;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }
  }
}
