package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ReturnInfoAdded implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.OrderMessagePayload {
  private ReturnInfo returnInfo;

  private String type;

  public ReturnInfoAdded() {
  }

  public ReturnInfoAdded(ReturnInfo returnInfo, String type) {
    this.returnInfo = returnInfo;
    this.type = type;
  }

  public ReturnInfo getReturnInfo() {
    return returnInfo;
  }

  public void setReturnInfo(ReturnInfo returnInfo) {
    this.returnInfo = returnInfo;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ReturnInfoAdded{returnInfo='" + returnInfo + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReturnInfoAdded that = (ReturnInfoAdded) o;
    return Objects.equals(returnInfo, that.returnInfo) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(returnInfo, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ReturnInfo returnInfo;

    private String type;

    public ReturnInfoAdded build() {
      ReturnInfoAdded result = new ReturnInfoAdded();
      result.returnInfo = this.returnInfo;
      result.type = this.type;
      return result;
    }

    public Builder returnInfo(ReturnInfo returnInfo) {
      this.returnInfo = returnInfo;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
