package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ReturnItemDraftType {
  private String key;

  private Long quantity;

  private String lineItemId;

  private String customLineItemId;

  private String comment;

  private ReturnShipmentState shipmentState;

  private CustomFieldsDraft custom;

  public ReturnItemDraftType() {
  }

  public ReturnItemDraftType(String key, Long quantity, String lineItemId, String customLineItemId,
      String comment, ReturnShipmentState shipmentState, CustomFieldsDraft custom) {
    this.key = key;
    this.quantity = quantity;
    this.lineItemId = lineItemId;
    this.customLineItemId = customLineItemId;
    this.comment = comment;
    this.shipmentState = shipmentState;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public ReturnShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ReturnShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ReturnItemDraftType{key='" + key + "', quantity='" + quantity + "', lineItemId='" + lineItemId + "', customLineItemId='" + customLineItemId + "', comment='" + comment + "', shipmentState='" + shipmentState + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReturnItemDraftType that = (ReturnItemDraftType) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(comment, that.comment) &&
        Objects.equals(shipmentState, that.shipmentState) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, quantity, lineItemId, customLineItemId, comment, shipmentState, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private Long quantity;

    private String lineItemId;

    private String customLineItemId;

    private String comment;

    private ReturnShipmentState shipmentState;

    private CustomFieldsDraft custom;

    public ReturnItemDraftType build() {
      ReturnItemDraftType result = new ReturnItemDraftType();
      result.key = this.key;
      result.quantity = this.quantity;
      result.lineItemId = this.lineItemId;
      result.customLineItemId = this.customLineItemId;
      result.comment = this.comment;
      result.shipmentState = this.shipmentState;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder comment(String comment) {
      this.comment = comment;
      return this;
    }

    public Builder shipmentState(ReturnShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
