package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RevertStagedChanges {
  private String dummy;

  public RevertStagedChanges() {
  }

  public RevertStagedChanges(String dummy) {
    this.dummy = dummy;
  }

  public String getDummy() {
    return dummy;
  }

  public void setDummy(String dummy) {
    this.dummy = dummy;
  }

  @Override
  public String toString() {
    return "RevertStagedChanges{dummy='" + dummy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RevertStagedChanges that = (RevertStagedChanges) o;
    return Objects.equals(dummy, that.dummy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dummy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String dummy;

    public RevertStagedChanges build() {
      RevertStagedChanges result = new RevertStagedChanges();
      result.dummy = this.dummy;
      return result;
    }

    public Builder dummy(String dummy) {
      this.dummy = dummy;
      return this;
    }
  }
}
