package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Review implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String key;

  private String uniquenessValue;

  private String locale;

  private String authorName;

  private String title;

  private String text;

  private Reference targetRef;

  private ReviewTarget target;

  private Integer rating;

  private Reference stateRef;

  private State state;

  private Boolean includedInStatistics;

  private Reference customerRef;

  private Customer customer;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Review() {
  }

  public Review(String key, String uniquenessValue, String locale, String authorName, String title,
      String text, Reference targetRef, ReviewTarget target, Integer rating, Reference stateRef,
      State state, Boolean includedInStatistics, Reference customerRef, Customer customer,
      CustomFieldsType custom, String id, Long version, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
    this.key = key;
    this.uniquenessValue = uniquenessValue;
    this.locale = locale;
    this.authorName = authorName;
    this.title = title;
    this.text = text;
    this.targetRef = targetRef;
    this.target = target;
    this.rating = rating;
    this.stateRef = stateRef;
    this.state = state;
    this.includedInStatistics = includedInStatistics;
    this.customerRef = customerRef;
    this.customer = customer;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getUniquenessValue() {
    return uniquenessValue;
  }

  public void setUniquenessValue(String uniquenessValue) {
    this.uniquenessValue = uniquenessValue;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public String getAuthorName() {
    return authorName;
  }

  public void setAuthorName(String authorName) {
    this.authorName = authorName;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  public Reference getTargetRef() {
    return targetRef;
  }

  public void setTargetRef(Reference targetRef) {
    this.targetRef = targetRef;
  }

  public ReviewTarget getTarget() {
    return target;
  }

  public void setTarget(ReviewTarget target) {
    this.target = target;
  }

  public Integer getRating() {
    return rating;
  }

  public void setRating(Integer rating) {
    this.rating = rating;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public Boolean getIncludedInStatistics() {
    return includedInStatistics;
  }

  public void setIncludedInStatistics(Boolean includedInStatistics) {
    this.includedInStatistics = includedInStatistics;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Review{key='" + key + "', uniquenessValue='" + uniquenessValue + "', locale='" + locale + "', authorName='" + authorName + "', title='" + title + "', text='" + text + "', targetRef='" + targetRef + "', target='" + target + "', rating='" + rating + "', stateRef='" + stateRef + "', state='" + state + "', includedInStatistics='" + includedInStatistics + "', customerRef='" + customerRef + "', customer='" + customer + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Review that = (Review) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(uniquenessValue, that.uniquenessValue) &&
        Objects.equals(locale, that.locale) &&
        Objects.equals(authorName, that.authorName) &&
        Objects.equals(title, that.title) &&
        Objects.equals(text, that.text) &&
        Objects.equals(targetRef, that.targetRef) &&
        Objects.equals(target, that.target) &&
        Objects.equals(rating, that.rating) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state) &&
        Objects.equals(includedInStatistics, that.includedInStatistics) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, uniquenessValue, locale, authorName, title, text, targetRef, target, rating, stateRef, state, includedInStatistics, customerRef, customer, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String uniquenessValue;

    private String locale;

    private String authorName;

    private String title;

    private String text;

    private Reference targetRef;

    private ReviewTarget target;

    private Integer rating;

    private Reference stateRef;

    private State state;

    private Boolean includedInStatistics;

    private Reference customerRef;

    private Customer customer;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Review build() {
      Review result = new Review();
      result.key = this.key;
      result.uniquenessValue = this.uniquenessValue;
      result.locale = this.locale;
      result.authorName = this.authorName;
      result.title = this.title;
      result.text = this.text;
      result.targetRef = this.targetRef;
      result.target = this.target;
      result.rating = this.rating;
      result.stateRef = this.stateRef;
      result.state = this.state;
      result.includedInStatistics = this.includedInStatistics;
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder uniquenessValue(String uniquenessValue) {
      this.uniquenessValue = uniquenessValue;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder authorName(String authorName) {
      this.authorName = authorName;
      return this;
    }

    public Builder title(String title) {
      this.title = title;
      return this;
    }

    public Builder text(String text) {
      this.text = text;
      return this;
    }

    public Builder targetRef(Reference targetRef) {
      this.targetRef = targetRef;
      return this;
    }

    public Builder target(ReviewTarget target) {
      this.target = target;
      return this;
    }

    public Builder rating(Integer rating) {
      this.rating = rating;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder includedInStatistics(Boolean includedInStatistics) {
      this.includedInStatistics = includedInStatistics;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
