package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ReviewCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private Review review;

  private String type;

  public ReviewCreated() {
  }

  public ReviewCreated(Review review, String type) {
    this.review = review;
    this.type = type;
  }

  public Review getReview() {
    return review;
  }

  public void setReview(Review review) {
    this.review = review;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ReviewCreated{review='" + review + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReviewCreated that = (ReviewCreated) o;
    return Objects.equals(review, that.review) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(review, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Review review;

    private String type;

    public ReviewCreated build() {
      ReviewCreated result = new ReviewCreated();
      result.review = this.review;
      result.type = this.type;
      return result;
    }

    public Builder review(Review review) {
      this.review = review;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
