package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ReviewRatingSet implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer oldRating;

  private Integer newRating;

  private Boolean includedInStatistics;

  private ReviewTarget target;

  private Reference targetRef;

  private String type;

  public ReviewRatingSet() {
  }

  public ReviewRatingSet(Integer oldRating, Integer newRating, Boolean includedInStatistics,
      ReviewTarget target, Reference targetRef, String type) {
    this.oldRating = oldRating;
    this.newRating = newRating;
    this.includedInStatistics = includedInStatistics;
    this.target = target;
    this.targetRef = targetRef;
    this.type = type;
  }

  public Integer getOldRating() {
    return oldRating;
  }

  public void setOldRating(Integer oldRating) {
    this.oldRating = oldRating;
  }

  public Integer getNewRating() {
    return newRating;
  }

  public void setNewRating(Integer newRating) {
    this.newRating = newRating;
  }

  public Boolean getIncludedInStatistics() {
    return includedInStatistics;
  }

  public void setIncludedInStatistics(Boolean includedInStatistics) {
    this.includedInStatistics = includedInStatistics;
  }

  public ReviewTarget getTarget() {
    return target;
  }

  public void setTarget(ReviewTarget target) {
    this.target = target;
  }

  public Reference getTargetRef() {
    return targetRef;
  }

  public void setTargetRef(Reference targetRef) {
    this.targetRef = targetRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ReviewRatingSet{oldRating='" + oldRating + "', newRating='" + newRating + "', includedInStatistics='" + includedInStatistics + "', target='" + target + "', targetRef='" + targetRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReviewRatingSet that = (ReviewRatingSet) o;
    return Objects.equals(oldRating, that.oldRating) &&
        Objects.equals(newRating, that.newRating) &&
        Objects.equals(includedInStatistics, that.includedInStatistics) &&
        Objects.equals(target, that.target) &&
        Objects.equals(targetRef, that.targetRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldRating, newRating, includedInStatistics, target, targetRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer oldRating;

    private Integer newRating;

    private Boolean includedInStatistics;

    private ReviewTarget target;

    private Reference targetRef;

    private String type;

    public ReviewRatingSet build() {
      ReviewRatingSet result = new ReviewRatingSet();
      result.oldRating = this.oldRating;
      result.newRating = this.newRating;
      result.includedInStatistics = this.includedInStatistics;
      result.target = this.target;
      result.targetRef = this.targetRef;
      result.type = this.type;
      return result;
    }

    public Builder oldRating(Integer oldRating) {
      this.oldRating = oldRating;
      return this;
    }

    public Builder newRating(Integer newRating) {
      this.newRating = newRating;
      return this;
    }

    public Builder includedInStatistics(Boolean includedInStatistics) {
      this.includedInStatistics = includedInStatistics;
      return this;
    }

    public Builder target(ReviewTarget target) {
      this.target = target;
      return this;
    }

    public Builder targetRef(Reference targetRef) {
      this.targetRef = targetRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
