package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ReviewUpdateAction {
  private SetReviewAuthorName setAuthorName;

  private SetReviewCustomField setCustomField;

  private SetReviewCustomType setCustomType;

  private SetReviewCustomer setCustomer;

  private SetReviewKey setKey;

  private SetReviewLocale setLocale;

  private SetReviewRating setRating;

  private SetReviewTarget setTarget;

  private SetReviewText setText;

  private SetReviewTitle setTitle;

  private TransitionReviewState transitionState;

  public ReviewUpdateAction() {
  }

  public ReviewUpdateAction(SetReviewAuthorName setAuthorName, SetReviewCustomField setCustomField,
      SetReviewCustomType setCustomType, SetReviewCustomer setCustomer, SetReviewKey setKey,
      SetReviewLocale setLocale, SetReviewRating setRating, SetReviewTarget setTarget,
      SetReviewText setText, SetReviewTitle setTitle, TransitionReviewState transitionState) {
    this.setAuthorName = setAuthorName;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setCustomer = setCustomer;
    this.setKey = setKey;
    this.setLocale = setLocale;
    this.setRating = setRating;
    this.setTarget = setTarget;
    this.setText = setText;
    this.setTitle = setTitle;
    this.transitionState = transitionState;
  }

  public SetReviewAuthorName getSetAuthorName() {
    return setAuthorName;
  }

  public void setSetAuthorName(SetReviewAuthorName setAuthorName) {
    this.setAuthorName = setAuthorName;
  }

  public SetReviewCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetReviewCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetReviewCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetReviewCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetReviewCustomer getSetCustomer() {
    return setCustomer;
  }

  public void setSetCustomer(SetReviewCustomer setCustomer) {
    this.setCustomer = setCustomer;
  }

  public SetReviewKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetReviewKey setKey) {
    this.setKey = setKey;
  }

  public SetReviewLocale getSetLocale() {
    return setLocale;
  }

  public void setSetLocale(SetReviewLocale setLocale) {
    this.setLocale = setLocale;
  }

  public SetReviewRating getSetRating() {
    return setRating;
  }

  public void setSetRating(SetReviewRating setRating) {
    this.setRating = setRating;
  }

  public SetReviewTarget getSetTarget() {
    return setTarget;
  }

  public void setSetTarget(SetReviewTarget setTarget) {
    this.setTarget = setTarget;
  }

  public SetReviewText getSetText() {
    return setText;
  }

  public void setSetText(SetReviewText setText) {
    this.setText = setText;
  }

  public SetReviewTitle getSetTitle() {
    return setTitle;
  }

  public void setSetTitle(SetReviewTitle setTitle) {
    this.setTitle = setTitle;
  }

  public TransitionReviewState getTransitionState() {
    return transitionState;
  }

  public void setTransitionState(TransitionReviewState transitionState) {
    this.transitionState = transitionState;
  }

  @Override
  public String toString() {
    return "ReviewUpdateAction{setAuthorName='" + setAuthorName + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setCustomer='" + setCustomer + "', setKey='" + setKey + "', setLocale='" + setLocale + "', setRating='" + setRating + "', setTarget='" + setTarget + "', setText='" + setText + "', setTitle='" + setTitle + "', transitionState='" + transitionState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReviewUpdateAction that = (ReviewUpdateAction) o;
    return Objects.equals(setAuthorName, that.setAuthorName) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setCustomer, that.setCustomer) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setLocale, that.setLocale) &&
        Objects.equals(setRating, that.setRating) &&
        Objects.equals(setTarget, that.setTarget) &&
        Objects.equals(setText, that.setText) &&
        Objects.equals(setTitle, that.setTitle) &&
        Objects.equals(transitionState, that.transitionState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(setAuthorName, setCustomField, setCustomType, setCustomer, setKey, setLocale, setRating, setTarget, setText, setTitle, transitionState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private SetReviewAuthorName setAuthorName;

    private SetReviewCustomField setCustomField;

    private SetReviewCustomType setCustomType;

    private SetReviewCustomer setCustomer;

    private SetReviewKey setKey;

    private SetReviewLocale setLocale;

    private SetReviewRating setRating;

    private SetReviewTarget setTarget;

    private SetReviewText setText;

    private SetReviewTitle setTitle;

    private TransitionReviewState transitionState;

    public ReviewUpdateAction build() {
      ReviewUpdateAction result = new ReviewUpdateAction();
      result.setAuthorName = this.setAuthorName;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setCustomer = this.setCustomer;
      result.setKey = this.setKey;
      result.setLocale = this.setLocale;
      result.setRating = this.setRating;
      result.setTarget = this.setTarget;
      result.setText = this.setText;
      result.setTitle = this.setTitle;
      result.transitionState = this.transitionState;
      return result;
    }

    public Builder setAuthorName(SetReviewAuthorName setAuthorName) {
      this.setAuthorName = setAuthorName;
      return this;
    }

    public Builder setCustomField(SetReviewCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetReviewCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setCustomer(SetReviewCustomer setCustomer) {
      this.setCustomer = setCustomer;
      return this;
    }

    public Builder setKey(SetReviewKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setLocale(SetReviewLocale setLocale) {
      this.setLocale = setLocale;
      return this;
    }

    public Builder setRating(SetReviewRating setRating) {
      this.setRating = setRating;
      return this;
    }

    public Builder setTarget(SetReviewTarget setTarget) {
      this.setTarget = setTarget;
      return this;
    }

    public Builder setText(SetReviewText setText) {
      this.setText = setText;
      return this;
    }

    public Builder setTitle(SetReviewTitle setTitle) {
      this.setTitle = setTitle;
      return this;
    }

    public Builder transitionState(TransitionReviewState transitionState) {
      this.transitionState = transitionState;
      return this;
    }
  }
}
