package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RuleApproverDraft {
  private ResourceIdentifierInput associateRole;

  public RuleApproverDraft() {
  }

  public RuleApproverDraft(ResourceIdentifierInput associateRole) {
    this.associateRole = associateRole;
  }

  public ResourceIdentifierInput getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(ResourceIdentifierInput associateRole) {
    this.associateRole = associateRole;
  }

  @Override
  public String toString() {
    return "RuleApproverDraft{associateRole='" + associateRole + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RuleApproverDraft that = (RuleApproverDraft) o;
    return Objects.equals(associateRole, that.associateRole);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRole);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput associateRole;

    public RuleApproverDraft build() {
      RuleApproverDraft result = new RuleApproverDraft();
      result.associateRole = this.associateRole;
      return result;
    }

    public Builder associateRole(ResourceIdentifierInput associateRole) {
      this.associateRole = associateRole;
      return this;
    }
  }
}
