package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RuleRequester {
  private AssociateRole associateRole;

  private KeyReference associateRoleRef;

  public RuleRequester() {
  }

  public RuleRequester(AssociateRole associateRole, KeyReference associateRoleRef) {
    this.associateRole = associateRole;
    this.associateRoleRef = associateRoleRef;
  }

  public AssociateRole getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(AssociateRole associateRole) {
    this.associateRole = associateRole;
  }

  public KeyReference getAssociateRoleRef() {
    return associateRoleRef;
  }

  public void setAssociateRoleRef(KeyReference associateRoleRef) {
    this.associateRoleRef = associateRoleRef;
  }

  @Override
  public String toString() {
    return "RuleRequester{associateRole='" + associateRole + "', associateRoleRef='" + associateRoleRef + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RuleRequester that = (RuleRequester) o;
    return Objects.equals(associateRole, that.associateRole) &&
        Objects.equals(associateRoleRef, that.associateRoleRef);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRole, associateRoleRef);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AssociateRole associateRole;

    private KeyReference associateRoleRef;

    public RuleRequester build() {
      RuleRequester result = new RuleRequester();
      result.associateRole = this.associateRole;
      result.associateRoleRef = this.associateRoleRef;
      return result;
    }

    public Builder associateRole(AssociateRole associateRole) {
      this.associateRole = associateRole;
      return this;
    }

    public Builder associateRoleRef(KeyReference associateRoleRef) {
      this.associateRoleRef = associateRoleRef;
      return this;
    }
  }
}
