package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class RuleRequesterDraft {
  private ResourceIdentifierInput associateRole;

  public RuleRequesterDraft() {
  }

  public RuleRequesterDraft(ResourceIdentifierInput associateRole) {
    this.associateRole = associateRole;
  }

  public ResourceIdentifierInput getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(ResourceIdentifierInput associateRole) {
    this.associateRole = associateRole;
  }

  @Override
  public String toString() {
    return "RuleRequesterDraft{associateRole='" + associateRole + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RuleRequesterDraft that = (RuleRequesterDraft) o;
    return Objects.equals(associateRole, that.associateRole);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRole);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput associateRole;

    public RuleRequesterDraft build() {
      RuleRequesterDraft result = new RuleRequesterDraft();
      result.associateRole = this.associateRole;
      return result;
    }

    public Builder associateRole(ResourceIdentifierInput associateRole) {
      this.associateRole = associateRole;
      return this;
    }
  }
}
