package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SNSDestinationInput {
  private String topicArn;

  private String accessKey;

  private String accessSecret;

  private AwsAuthenticationMode authenticationMode = AwsAuthenticationMode.Credentials;

  public SNSDestinationInput() {
  }

  public SNSDestinationInput(String topicArn, String accessKey, String accessSecret,
      AwsAuthenticationMode authenticationMode) {
    this.topicArn = topicArn;
    this.accessKey = accessKey;
    this.accessSecret = accessSecret;
    this.authenticationMode = authenticationMode;
  }

  public String getTopicArn() {
    return topicArn;
  }

  public void setTopicArn(String topicArn) {
    this.topicArn = topicArn;
  }

  public String getAccessKey() {
    return accessKey;
  }

  public void setAccessKey(String accessKey) {
    this.accessKey = accessKey;
  }

  public String getAccessSecret() {
    return accessSecret;
  }

  public void setAccessSecret(String accessSecret) {
    this.accessSecret = accessSecret;
  }

  public AwsAuthenticationMode getAuthenticationMode() {
    return authenticationMode;
  }

  public void setAuthenticationMode(AwsAuthenticationMode authenticationMode) {
    this.authenticationMode = authenticationMode;
  }

  @Override
  public String toString() {
    return "SNSDestinationInput{topicArn='" + topicArn + "', accessKey='" + accessKey + "', accessSecret='" + accessSecret + "', authenticationMode='" + authenticationMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SNSDestinationInput that = (SNSDestinationInput) o;
    return Objects.equals(topicArn, that.topicArn) &&
        Objects.equals(accessKey, that.accessKey) &&
        Objects.equals(accessSecret, that.accessSecret) &&
        Objects.equals(authenticationMode, that.authenticationMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(topicArn, accessKey, accessSecret, authenticationMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String topicArn;

    private String accessKey;

    private String accessSecret;

    private AwsAuthenticationMode authenticationMode = AwsAuthenticationMode.Credentials;

    public SNSDestinationInput build() {
      SNSDestinationInput result = new SNSDestinationInput();
      result.topicArn = this.topicArn;
      result.accessKey = this.accessKey;
      result.accessSecret = this.accessSecret;
      result.authenticationMode = this.authenticationMode;
      return result;
    }

    public Builder topicArn(String topicArn) {
      this.topicArn = topicArn;
      return this;
    }

    public Builder accessKey(String accessKey) {
      this.accessKey = accessKey;
      return this;
    }

    public Builder accessSecret(String accessSecret) {
      this.accessSecret = accessSecret;
      return this;
    }

    public Builder authenticationMode(AwsAuthenticationMode authenticationMode) {
      this.authenticationMode = authenticationMode;
      return this;
    }
  }
}
