package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ScoreShippingRateInput implements com.commercetools.graphql.api.types.ShippingRateInput {
  private Integer score;

  private String type;

  public ScoreShippingRateInput() {
  }

  public ScoreShippingRateInput(Integer score, String type) {
    this.score = score;
    this.type = type;
  }

  public Integer getScore() {
    return score;
  }

  public void setScore(Integer score) {
    this.score = score;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ScoreShippingRateInput{score='" + score + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ScoreShippingRateInput that = (ScoreShippingRateInput) o;
    return Objects.equals(score, that.score) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(score, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer score;

    private String type;

    public ScoreShippingRateInput build() {
      ScoreShippingRateInput result = new ScoreShippingRateInput();
      result.score = this.score;
      result.type = this.type;
      return result;
    }

    public Builder score(Integer score) {
      this.score = score;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
