package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchFacetInput {
  private SearchFacetModelInput model;

  private String string;

  public SearchFacetInput() {
  }

  public SearchFacetInput(SearchFacetModelInput model, String string) {
    this.model = model;
    this.string = string;
  }

  public SearchFacetModelInput getModel() {
    return model;
  }

  public void setModel(SearchFacetModelInput model) {
    this.model = model;
  }

  public String getString() {
    return string;
  }

  public void setString(String string) {
    this.string = string;
  }

  @Override
  public String toString() {
    return "SearchFacetInput{model='" + model + "', string='" + string + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchFacetInput that = (SearchFacetInput) o;
    return Objects.equals(model, that.model) &&
        Objects.equals(string, that.string);
  }

  @Override
  public int hashCode() {
    return Objects.hash(model, string);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private SearchFacetModelInput model;

    private String string;

    public SearchFacetInput build() {
      SearchFacetInput result = new SearchFacetInput();
      result.model = this.model;
      result.string = this.string;
      return result;
    }

    public Builder model(SearchFacetModelInput model) {
      this.model = model;
      return this;
    }

    public Builder string(String string) {
      this.string = string;
      return this;
    }
  }
}
