package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchFacetModelInput {
  private TermsFacetInput terms;

  private RangeFacetInput range;

  public SearchFacetModelInput() {
  }

  public SearchFacetModelInput(TermsFacetInput terms, RangeFacetInput range) {
    this.terms = terms;
    this.range = range;
  }

  public TermsFacetInput getTerms() {
    return terms;
  }

  public void setTerms(TermsFacetInput terms) {
    this.terms = terms;
  }

  public RangeFacetInput getRange() {
    return range;
  }

  public void setRange(RangeFacetInput range) {
    this.range = range;
  }

  @Override
  public String toString() {
    return "SearchFacetModelInput{terms='" + terms + "', range='" + range + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchFacetModelInput that = (SearchFacetModelInput) o;
    return Objects.equals(terms, that.terms) &&
        Objects.equals(range, that.range);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terms, range);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TermsFacetInput terms;

    private RangeFacetInput range;

    public SearchFacetModelInput build() {
      SearchFacetModelInput result = new SearchFacetModelInput();
      result.terms = this.terms;
      result.range = this.range;
      return result;
    }

    public Builder terms(TermsFacetInput terms) {
      this.terms = terms;
      return this;
    }

    public Builder range(RangeFacetInput range) {
      this.range = range;
      return this;
    }
  }
}
