package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchFilterModelInput {
  private ValueFilterInput value;

  private RangeFilterInput range;

  private MissingFilterInput missing;

  private ExistsFilterInput exists;

  private TreeFilterInput tree;

  public SearchFilterModelInput() {
  }

  public SearchFilterModelInput(ValueFilterInput value, RangeFilterInput range,
      MissingFilterInput missing, ExistsFilterInput exists, TreeFilterInput tree) {
    this.value = value;
    this.range = range;
    this.missing = missing;
    this.exists = exists;
    this.tree = tree;
  }

  public ValueFilterInput getValue() {
    return value;
  }

  public void setValue(ValueFilterInput value) {
    this.value = value;
  }

  public RangeFilterInput getRange() {
    return range;
  }

  public void setRange(RangeFilterInput range) {
    this.range = range;
  }

  public MissingFilterInput getMissing() {
    return missing;
  }

  public void setMissing(MissingFilterInput missing) {
    this.missing = missing;
  }

  public ExistsFilterInput getExists() {
    return exists;
  }

  public void setExists(ExistsFilterInput exists) {
    this.exists = exists;
  }

  public TreeFilterInput getTree() {
    return tree;
  }

  public void setTree(TreeFilterInput tree) {
    this.tree = tree;
  }

  @Override
  public String toString() {
    return "SearchFilterModelInput{value='" + value + "', range='" + range + "', missing='" + missing + "', exists='" + exists + "', tree='" + tree + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchFilterModelInput that = (SearchFilterModelInput) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(range, that.range) &&
        Objects.equals(missing, that.missing) &&
        Objects.equals(exists, that.exists) &&
        Objects.equals(tree, that.tree);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, range, missing, exists, tree);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ValueFilterInput value;

    private RangeFilterInput range;

    private MissingFilterInput missing;

    private ExistsFilterInput exists;

    private TreeFilterInput tree;

    public SearchFilterModelInput build() {
      SearchFilterModelInput result = new SearchFilterModelInput();
      result.value = this.value;
      result.range = this.range;
      result.missing = this.missing;
      result.exists = this.exists;
      result.tree = this.tree;
      return result;
    }

    public Builder value(ValueFilterInput value) {
      this.value = value;
      return this;
    }

    public Builder range(RangeFilterInput range) {
      this.range = range;
      return this;
    }

    public Builder missing(MissingFilterInput missing) {
      this.missing = missing;
      return this;
    }

    public Builder exists(ExistsFilterInput exists) {
      this.exists = exists;
      return this;
    }

    public Builder tree(TreeFilterInput tree) {
      this.tree = tree;
      return this;
    }
  }
}
