package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchKeywordArgument {
  private String searchKeyword;

  private String locale;

  public SearchKeywordArgument() {
  }

  public SearchKeywordArgument(String searchKeyword, String locale) {
    this.searchKeyword = searchKeyword;
    this.locale = locale;
  }

  public String getSearchKeyword() {
    return searchKeyword;
  }

  public void setSearchKeyword(String searchKeyword) {
    this.searchKeyword = searchKeyword;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  @Override
  public String toString() {
    return "SearchKeywordArgument{searchKeyword='" + searchKeyword + "', locale='" + locale + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchKeywordArgument that = (SearchKeywordArgument) o;
    return Objects.equals(searchKeyword, that.searchKeyword) &&
        Objects.equals(locale, that.locale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(searchKeyword, locale);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String searchKeyword;

    private String locale;

    public SearchKeywordArgument build() {
      SearchKeywordArgument result = new SearchKeywordArgument();
      result.searchKeyword = this.searchKeyword;
      result.locale = this.locale;
      return result;
    }

    public Builder searchKeyword(String searchKeyword) {
      this.searchKeyword = searchKeyword;
      return this;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }
  }
}
