package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchKeywordItemInput {
  private String text;

  private BaseSearchKeywordInput suggestTokenizer;

  public SearchKeywordItemInput() {
  }

  public SearchKeywordItemInput(String text, BaseSearchKeywordInput suggestTokenizer) {
    this.text = text;
    this.suggestTokenizer = suggestTokenizer;
  }

  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  public BaseSearchKeywordInput getSuggestTokenizer() {
    return suggestTokenizer;
  }

  public void setSuggestTokenizer(BaseSearchKeywordInput suggestTokenizer) {
    this.suggestTokenizer = suggestTokenizer;
  }

  @Override
  public String toString() {
    return "SearchKeywordItemInput{text='" + text + "', suggestTokenizer='" + suggestTokenizer + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchKeywordItemInput that = (SearchKeywordItemInput) o;
    return Objects.equals(text, that.text) &&
        Objects.equals(suggestTokenizer, that.suggestTokenizer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, suggestTokenizer);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String text;

    private BaseSearchKeywordInput suggestTokenizer;

    public SearchKeywordItemInput build() {
      SearchKeywordItemInput result = new SearchKeywordItemInput();
      result.text = this.text;
      result.suggestTokenizer = this.suggestTokenizer;
      return result;
    }

    public Builder text(String text) {
      this.text = text;
      return this;
    }

    public Builder suggestTokenizer(BaseSearchKeywordInput suggestTokenizer) {
      this.suggestTokenizer = suggestTokenizer;
      return this;
    }
  }
}
