package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SearchLimitsProjection {
  private Limit maxTextSize;

  public SearchLimitsProjection() {
  }

  public SearchLimitsProjection(Limit maxTextSize) {
    this.maxTextSize = maxTextSize;
  }

  public Limit getMaxTextSize() {
    return maxTextSize;
  }

  public void setMaxTextSize(Limit maxTextSize) {
    this.maxTextSize = maxTextSize;
  }

  @Override
  public String toString() {
    return "SearchLimitsProjection{maxTextSize='" + maxTextSize + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SearchLimitsProjection that = (SearchLimitsProjection) o;
    return Objects.equals(maxTextSize, that.maxTextSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxTextSize);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit maxTextSize;

    public SearchLimitsProjection build() {
      SearchLimitsProjection result = new SearchLimitsProjection();
      result.maxTextSize = this.maxTextSize;
      return result;
    }

    public Builder maxTextSize(Limit maxTextSize) {
      this.maxTextSize = maxTextSize;
      return this;
    }
  }
}
