package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetApprovalRuleDescription {
  private String description;

  public SetApprovalRuleDescription() {
  }

  public SetApprovalRuleDescription(String description) {
    this.description = description;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @Override
  public String toString() {
    return "SetApprovalRuleDescription{description='" + description + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetApprovalRuleDescription that = (SetApprovalRuleDescription) o;
    return Objects.equals(description, that.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String description;

    public SetApprovalRuleDescription build() {
      SetApprovalRuleDescription result = new SetApprovalRuleDescription();
      result.description = this.description;
      return result;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }
  }
}
