package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetAssociateRolePermissions {
  private List<Permission> permissions;

  public SetAssociateRolePermissions() {
  }

  public SetAssociateRolePermissions(List<Permission> permissions) {
    this.permissions = permissions;
  }

  public List<Permission> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<Permission> permissions) {
    this.permissions = permissions;
  }

  @Override
  public String toString() {
    return "SetAssociateRolePermissions{permissions='" + permissions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetAssociateRolePermissions that = (SetAssociateRolePermissions) o;
    return Objects.equals(permissions, that.permissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permissions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Permission> permissions;

    public SetAssociateRolePermissions build() {
      SetAssociateRolePermissions result = new SetAssociateRolePermissions();
      result.permissions = this.permissions;
      return result;
    }

    public Builder permissions(List<Permission> permissions) {
      this.permissions = permissions;
      return this;
    }
  }
}
