package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetAttributeGroupAttributes {
  private List<AttributeReferenceInput> attributes;

  public SetAttributeGroupAttributes() {
  }

  public SetAttributeGroupAttributes(List<AttributeReferenceInput> attributes) {
    this.attributes = attributes;
  }

  public List<AttributeReferenceInput> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<AttributeReferenceInput> attributes) {
    this.attributes = attributes;
  }

  @Override
  public String toString() {
    return "SetAttributeGroupAttributes{attributes='" + attributes + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetAttributeGroupAttributes that = (SetAttributeGroupAttributes) o;
    return Objects.equals(attributes, that.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<AttributeReferenceInput> attributes;

    public SetAttributeGroupAttributes build() {
      SetAttributeGroupAttributes result = new SetAttributeGroupAttributes();
      result.attributes = this.attributes;
      return result;
    }

    public Builder attributes(List<AttributeReferenceInput> attributes) {
      this.attributes = attributes;
      return this;
    }
  }
}
