package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetBusinessUnitAddressCustomField {
  private String addressId;

  private String addressKey;

  private String name;

  private String value;

  public SetBusinessUnitAddressCustomField() {
  }

  public SetBusinessUnitAddressCustomField(String addressId, String addressKey, String name,
      String value) {
    this.addressId = addressId;
    this.addressKey = addressKey;
    this.name = name;
    this.value = value;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetBusinessUnitAddressCustomField{addressId='" + addressId + "', addressKey='" + addressKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetBusinessUnitAddressCustomField that = (SetBusinessUnitAddressCustomField) o;
    return Objects.equals(addressId, that.addressId) &&
        Objects.equals(addressKey, that.addressKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressId, addressKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String addressId;

    private String addressKey;

    private String name;

    private String value;

    public SetBusinessUnitAddressCustomField build() {
      SetBusinessUnitAddressCustomField result = new SetBusinessUnitAddressCustomField();
      result.addressId = this.addressId;
      result.addressKey = this.addressKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
