package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetBusinessUnitStoreMode {
  private List<ResourceIdentifierInput> stores;

  private String storeMode;

  public SetBusinessUnitStoreMode() {
  }

  public SetBusinessUnitStoreMode(List<ResourceIdentifierInput> stores, String storeMode) {
    this.stores = stores;
    this.storeMode = storeMode;
  }

  public List<ResourceIdentifierInput> getStores() {
    return stores;
  }

  public void setStores(List<ResourceIdentifierInput> stores) {
    this.stores = stores;
  }

  public String getStoreMode() {
    return storeMode;
  }

  public void setStoreMode(String storeMode) {
    this.storeMode = storeMode;
  }

  @Override
  public String toString() {
    return "SetBusinessUnitStoreMode{stores='" + stores + "', storeMode='" + storeMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetBusinessUnitStoreMode that = (SetBusinessUnitStoreMode) o;
    return Objects.equals(stores, that.stores) &&
        Objects.equals(storeMode, that.storeMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stores, storeMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ResourceIdentifierInput> stores;

    private String storeMode;

    public SetBusinessUnitStoreMode build() {
      SetBusinessUnitStoreMode result = new SetBusinessUnitStoreMode();
      result.stores = this.stores;
      result.storeMode = this.storeMode;
      return result;
    }

    public Builder stores(List<ResourceIdentifierInput> stores) {
      this.stores = stores;
      return this;
    }

    public Builder storeMode(String storeMode) {
      this.storeMode = storeMode;
      return this;
    }
  }
}
